name: base
version: 1.196
description: The standard theory library
author: Joe Leslie-Hurd <joe@gilith.com>
license: MIT
show: "Data.Bool"
show: "Data.List"
show: "Data.Option"
show: "Data.Pair"
show: "Data.Sum"
show: "Data.Unit"
show: "Function"
show: "Number.Natural"
show: "Number.Real"
show: "Relation"
show: "Set"
haskell-name: opentheory
haskell-int-file: haskell.int
haskell-src-file: haskell.art
haskell-test-file: haskell-test.art
haskell-equality-type: "Data.List.list"
haskell-equality-type: "Data.Option.option"
haskell-equality-type: "Data.Pair.*"
haskell-equality-type: "Data.Sum.+"
haskell-equality-type: "Number.Natural.natural"
haskell-arbitrary-type: "Data.List.list"
haskell-arbitrary-type: "Data.Option.option"
haskell-arbitrary-type: "Data.Pair.*"
haskell-arbitrary-type: "Data.Sum.+"
haskell-arbitrary-type: "Number.Natural.natural"

bool {
  package: bool-1.36
  checksum: e32a8773b452a57dd074d284f71d77234e1f9fbf
}

unit {
  import: bool
  package: unit-1.20
  checksum: 5b2b994769e08238aa28f615334e67c6b1088a83
}

function {
  import: bool
  package: function-1.55
  checksum: 35d4e6c28baaee5cee8c39751d651af7d7cfe5dc
}

pair {
  import: bool
  package: pair-1.27
  checksum: f8df648f6ee40dfb722100bee9a9c8d10b64f078
}

natural {
  import: bool
  import: function
  package: natural-1.104
  checksum: 0a1c988d7a937154bd03f252ffcad3149485514c
}

set {
  import: bool
  import: function
  import: pair
  import: natural
  package: set-1.71
  checksum: d24337873baced38bef16c4ddb5a8c8593202453
}

relation {
  import: bool
  import: function
  import: pair
  import: natural
  import: set
  package: relation-1.60
  checksum: 0e88f90d6c85170311aefd11cff4779f23c65add
}

sum {
  import: bool
  import: pair
  import: natural
  package: sum-1.61
  checksum: b308349b08d4b77294d83a789a1ecb56a7359c44
}

option {
  import: bool
  import: function
  import: natural
  package: option-1.72
  checksum: de65c07af309d3986ad380dfb7329c4faae24abf
}

list {
  import: bool
  import: function
  import: pair
  import: natural
  import: set
  package: list-1.103
  checksum: 05e7d81c4b9498333620e792e0e85a0ea29f89f1
}

real {
  import: bool
  import: function
  import: pair
  import: natural
  import: set
  package: real-1.61
  checksum: 4eb38ef27f905a03c025066f45722bb05fc6eda9
}

main {
  import: bool
  import: unit
  import: function
  import: pair
  import: natural
  import: set
  import: relation
  import: sum
  import: option
  import: list
  import: real
}
