name: base
version: 1.209
description: The standard theory library
author: Joe Leslie-Hurd <joe@gilith.com>
license: MIT
homepage: http://opentheory.gilith.com/?pkg=base
show: "Data.Bool"
show: "Data.List"
show: "Data.Option"
show: "Data.Pair"
show: "Data.Sum"
show: "Data.Unit"
show: "Function"
show: "Number.Natural"
show: "Number.Real"
show: "Relation"
show: "Set"
haskell-name: opentheory
haskell-int-file: haskell.int
haskell-src-file: haskell.art
haskell-test-file: haskell-test.art
haskell-equality-type: "Data.List.list"
haskell-equality-type: "Data.Option.option"
haskell-equality-type: "Data.Pair.*"
haskell-equality-type: "Data.Sum.+"
haskell-equality-type: "Number.Natural.natural"
haskell-arbitrary-type: "Data.List.list"
haskell-arbitrary-type: "Data.Option.option"
haskell-arbitrary-type: "Data.Pair.*"
haskell-arbitrary-type: "Data.Sum.+"
haskell-arbitrary-type: "Number.Natural.natural"

bool {
  package: bool-1.37
  checksum: 3ce9f58a6d6373bd7540fd16b482130ece4799b8
}

unit {
  import: bool
  package: unit-1.20
  checksum: 5b2b994769e08238aa28f615334e67c6b1088a83
}

function {
  import: bool
  package: function-1.55
  checksum: 35d4e6c28baaee5cee8c39751d651af7d7cfe5dc
}

pair {
  import: bool
  import: function
  package: pair-1.29
  checksum: 4d9d8f6992e8332cdfcfb3dc96e225f4a430c463
}

natural {
  import: bool
  import: function
  package: natural-1.107
  checksum: 37061e26497136eebe36d86fe0b8031eb1ae27a6
}

set {
  import: bool
  import: function
  import: pair
  import: natural
  package: set-1.79
  checksum: e16ebe7c2d772315703c676e606aa12a094603a9
}

relation {
  import: bool
  import: function
  import: pair
  import: natural
  import: set
  package: relation-1.62
  checksum: d20cf34fbb5b138caeb6fd110c65245380d32643
}

sum {
  import: bool
  import: pair
  import: natural
  package: sum-1.61
  checksum: b308349b08d4b77294d83a789a1ecb56a7359c44
}

option {
  import: bool
  import: function
  import: natural
  package: option-1.72
  checksum: de65c07af309d3986ad380dfb7329c4faae24abf
}

list {
  import: bool
  import: function
  import: pair
  import: natural
  import: set
  package: list-1.105
  checksum: b2df084e0ec28cf378542ec3fe329e14ffa782dc
}

real {
  import: bool
  import: function
  import: pair
  import: natural
  import: set
  package: real-1.61
  checksum: 4eb38ef27f905a03c025066f45722bb05fc6eda9
}

main {
  import: bool
  import: unit
  import: function
  import: pair
  import: natural
  import: set
  import: relation
  import: sum
  import: option
  import: list
  import: real
}
