name: hardware
version: 1.77
description: Hardware devices
author: Joe Leslie-Hurd <joe@gilith.com>
license: MIT
requires: bool
requires: function
requires: list
requires: natural
requires: natural-bits
requires: pair
requires: set
requires: stream
show: "Data.Bool"
show: "Data.List"
show: "Data.Pair"
show: "Data.Stream"
show: "Function"
show: "Hardware"
show: "Number.Natural"
show: "Set"

def {
  package: hardware-def-1.20
  checksum: c5e669c2918798e17458389f6035ffcaa0ff4342
}

thm {
  import: def
  package: hardware-thm-1.32
  checksum: 3ce9f66c17d4e8e3953b5f19c1b70ce6e3c78a90
}

wire {
  import: thm
  package: hardware-wire-1.22
  checksum: fb92094e3fd3c0f7a56ed1270787584b4eb284b9
}

bus {
  import: thm
  import: wire
  package: hardware-bus-1.45
  checksum: 25ecab359639b55569e4fc779ad4f758d82f3ba5
}

adder {
  import: thm
  import: wire
  import: bus
  package: hardware-adder-1.17
  checksum: df16311c65888820932f7f57fbeb31dcd4b77951
}

counter {
  import: def
  import: thm
  import: wire
  import: bus
  import: adder
  package: hardware-counter-1.20
  checksum: d2cd056118ffcb847f5ae6140267129e6c6d8adf
}

multiplier {
  import: thm
  import: bus
  import: counter
  import: adder
  package: hardware-multiplier-1.16
  checksum: 01ecc2698eec85b1dee4cb70987cfd88bac16d19
}

main {
  import: def
  import: thm
  import: wire
  import: bus
  import: adder
  import: counter
  import: multiplier
}
