name: hardware
version: 1.83
description: Hardware devices
author: Joe Leslie-Hurd <joe@gilith.com>
license: MIT
requires: base
requires: natural-bits
requires: stream
show: "Data.Bool"
show: "Data.List"
show: "Data.Pair"
show: "Data.Stream"
show: "Function"
show: "Hardware"
show: "Number.Natural"
show: "Set"
hol-light-int-file: hol-light.int
hol-light-thm-file: hol-light.art

def {
  package: hardware-def-1.21
  checksum: 57a720b860eec336c8df6a5b95175283225194bc
}

thm {
  import: def
  package: hardware-thm-1.33
  checksum: 6ed467b332696f73bd666e1ff3a9be72ced80d22
}

wire {
  import: thm
  package: hardware-wire-1.23
  checksum: cefd0f48eee39a598bed0d3ae5a66e7c31efbb56
}

bus {
  import: thm
  import: wire
  package: hardware-bus-1.46
  checksum: 124cdc9ab0448e0245bd773199a5b6f9aafe2c9c
}

adder {
  import: thm
  import: wire
  import: bus
  package: hardware-adder-1.18
  checksum: 2b3e188b0e1fffdb14df3fa6065c52dd28290bae
}

counter {
  import: def
  import: thm
  import: wire
  import: bus
  import: adder
  package: hardware-counter-1.21
  checksum: 90b2dd44c45aa3a0adb74cf48418164a4af22462
}

multiplier {
  import: thm
  import: bus
  import: counter
  import: adder
  package: hardware-multiplier-1.18
  checksum: 40abc6522d33001cd5451c1778ddd5868d4a2ae0
}

main {
  import: def
  import: thm
  import: wire
  import: bus
  import: adder
  import: counter
  import: multiplier
}
