name: list
version: 1.11
description: Basic theory of list types
author: Joe Hurd <joe@gilith.com>
license: MIT
show: "Data.Bool"
show: "Data.List"
show: "Function"
show: "Number.Natural"
show: "Number.Numeral"

def {
  package: list-def-1.7
}

thm {
  import: def
  package: list-thm-1.8
}

dest {
  import: def
  import: thm
  package: list-dest-1.9
}

length {
  import: def
  import: thm
  import: dest
  package: list-length-1.8
}

set {
  import: def
  import: thm
  import: length
  package: list-set-1.7
}

append {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  package: list-append-1.8
}

map {
  import: def
  import: thm
  import: length
  import: set
  import: append
  package: list-map-1.8
}

quant {
  import: def
  import: append
  import: map
  package: list-quant-1.7
}

filter {
  import: def
  import: length
  import: set
  import: append
  import: map
  package: list-filter-1.8
}

last {
  import: def
  import: thm
  import: set
  import: append
  package: list-last-1.8
}

reverse {
  import: def
  import: length
  import: set
  import: append
  package: list-reverse-1.8
}

nth {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  import: append
  import: map
  import: last
  package: list-nth-1.8
}

replicate {
  import: length
  import: set
  import: nth
  package: list-replicate-1.8
}

member {
  import: def
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: filter
  import: reverse
  import: nth
  package: list-member-1.10
}

concat {
  import: def
  import: dest
  import: append
  import: quant
  package: list-concat-1.9
}

take-drop {
  import: def
  import: thm
  import: dest
  import: length
  import: append
  import: nth
  package: list-take-drop-1.9
}

interval {
  import: length
  import: nth
  package: list-interval-1.9
}

zipwith {
  import: def
  import: dest
  import: length
  package: list-zipwith-1.9
}

nub {
  import: def
  import: length
  import: reverse
  import: member
  package: list-nub-1.9
}

main {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: filter
  import: last
  import: reverse
  import: nth
  import: replicate
  import: member
  import: concat
  import: take-drop
  import: interval
  import: zipwith
  import: nub
}
