name: list
version: 1.20
description: Standard theory of lists
author: Joe Hurd <joe@gilith.com>
license: MIT
show: "Data.Bool"
show: "Data.List"
show: "Function"
show: "Number.Natural"

def {
  package: list-def-1.11
}

thm {
  import: def
  package: list-thm-1.11
}

dest {
  import: def
  import: thm
  package: list-dest-1.13
}

length {
  import: def
  import: thm
  import: dest
  package: list-length-1.12
}

set {
  import: def
  import: thm
  import: length
  package: list-set-1.12
}

append {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  package: list-append-1.12
}

map {
  import: def
  import: thm
  import: length
  import: set
  import: append
  package: list-map-1.12
}

quant {
  import: def
  import: set
  import: append
  import: map
  package: list-quant-1.10
}

filter {
  import: def
  import: length
  import: set
  import: append
  import: map
  package: list-filter-1.12
}

last {
  import: def
  import: thm
  import: set
  import: append
  package: list-last-1.12
}

reverse {
  import: def
  import: length
  import: set
  import: append
  package: list-reverse-1.12
}

nth {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: last
  package: list-nth-1.13
}

replicate {
  import: length
  import: set
  import: nth
  package: list-replicate-1.12
}

member {
  import: def
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: filter
  import: reverse
  import: nth
  package: list-member-1.15
}

concat {
  import: def
  import: dest
  import: append
  import: quant
  package: list-concat-1.12
}

take-drop {
  import: def
  import: thm
  import: dest
  import: length
  import: append
  import: nth
  package: list-take-drop-1.13
}

interval {
  import: length
  import: nth
  package: list-interval-1.13
}

zipwith {
  import: def
  import: dest
  import: length
  package: list-zipwith-1.13
}

nub {
  import: def
  import: length
  import: reverse
  import: member
  package: list-nub-1.15
}

main {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: filter
  import: last
  import: reverse
  import: nth
  import: replicate
  import: member
  import: concat
  import: take-drop
  import: interval
  import: zipwith
  import: nub
}
