name: list
version: 1.51
description: List types
author: Joe Hurd <joe@gilith.com>
license: MIT
requires: bool
requires: function
requires: pair
requires: natural
requires: set
show: "Data.Bool"
show: "Data.List"
show: "Data.Pair"
show: "Function"
show: "Number.Natural"
show: "Set"

def {
  package: list-def-1.39
}

thm {
  import: def
  package: list-thm-1.32
}

dest {
  import: def
  import: thm
  package: list-dest-1.28
}

length {
  import: def
  import: thm
  import: dest
  package: list-length-1.30
}

set {
  import: def
  import: thm
  import: length
  package: list-set-1.30
}

append {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  package: list-append-1.30
}

map {
  import: def
  import: thm
  import: length
  import: set
  import: append
  package: list-map-1.31
}

quant {
  import: def
  import: set
  import: append
  import: map
  package: list-quant-1.30
}

filter {
  import: def
  import: length
  import: set
  import: append
  import: map
  import: quant
  package: list-filter-1.31
}

last {
  import: def
  import: thm
  import: set
  import: append
  package: list-last-1.31
}

reverse {
  import: def
  import: length
  import: set
  import: append
  import: map
  package: list-reverse-1.28
}

fold {
  import: def
  import: length
  import: append
  import: reverse
  package: list-fold-1.5
}

nth {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: last
  package: list-nth-1.34
}

replicate {
  import: length
  import: set
  import: nth
  package: list-replicate-1.32
}

member {
  import: def
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: filter
  import: reverse
  import: nth
  package: list-member-1.36
}

concat {
  import: def
  import: dest
  import: append
  import: quant
  package: list-concat-1.29
}

take-drop {
  import: def
  import: thm
  import: dest
  import: length
  import: append
  import: nth
  package: list-take-drop-1.33
}

interval {
  import: length
  import: nth
  package: list-interval-1.34
}

zipwith {
  import: def
  import: dest
  import: length
  package: list-zipwith-1.31
}

nub {
  import: def
  import: length
  import: reverse
  import: member
  package: list-nub-1.34
}

main {
  import: def
  import: thm
  import: dest
  import: length
  import: set
  import: append
  import: map
  import: quant
  import: filter
  import: last
  import: reverse
  import: fold
  import: nth
  import: replicate
  import: member
  import: concat
  import: take-drop
  import: interval
  import: zipwith
  import: nub
}
